/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import me.ultrusmods.missingwilds.Constants;

public class ColorSets {
    public static final HashMap<String, ColorSet> COLOR_SETS = new HashMap();
    private static final Gson GSON = new GsonBuilder().create();

    public static void addSpecialColors() {
        CompletableFuture.runAsync(() -> {
            try {
                InputStreamReader reader = new InputStreamReader(new URL("https://gist.githubusercontent.com/UltrusBot/1cc799aa2657d49d2a2cffbec8f242a8/raw/colors.json").openStream());
                ColorSet[] colors = (ColorSet[])GSON.fromJson((Reader)reader, ColorSet[].class);
                Arrays.stream(colors).forEach(ColorSet::addToMap);
            }
            catch (MalformedURLException e) {
                Constants.LOG.error("Malformed URL for color sets! Error: " + e.getMessage());
            }
            catch (IOException e) {
                Constants.LOG.error("Error reading color sets! Error: " + e.getMessage());
            }
            catch (Exception e) {
                Constants.LOG.error("Unknown error reading color sets! Error: " + e.getMessage());
            }
        });
    }

    private static void addColorSet(String name, Integer[] ... colors) {
        COLOR_SETS.put(name, new ColorSet(name, colors));
    }

    private static Integer[] color(int r, int g, int b) {
        return new Integer[]{r, g, b};
    }

    static {
        ColorSets.addColorSet("pride", ColorSets.color(228, 3, 3), ColorSets.color(255, 140, 0), ColorSets.color(255, 237, 0), ColorSets.color(0, 128, 38), ColorSets.color(36, 64, 142), ColorSets.color(115, 41, 130));
        ColorSets.addColorSet("trans", ColorSets.color(91, 206, 250), ColorSets.color(245, 169, 184), ColorSets.color(255, 255, 255));
        ColorSets.addColorSet("bi", ColorSets.color(214, 2, 112), ColorSets.color(155, 79, 150), ColorSets.color(0, 56, 168));
        ColorSets.addColorSet("pan", ColorSets.color(255, 33, 140), ColorSets.color(255, 216, 0), ColorSets.color(33, 177, 255));
        ColorSets.addColorSet("lesbian", ColorSets.color(213, 45, 0), ColorSets.color(239, 118, 39), ColorSets.color(255, 154, 86), ColorSets.color(255, 255, 255), ColorSets.color(209, 98, 164), ColorSets.color(181, 86, 144), ColorSets.color(163, 2, 98));
        ColorSets.addColorSet("genderfluid", ColorSets.color(255, 118, 164), ColorSets.color(255, 255, 255), ColorSets.color(192, 17, 215), ColorSets.color(0, 0, 0), ColorSets.color(47, 60, 190));
        ColorSets.addColorSet("asexual", ColorSets.color(0, 0, 0), ColorSets.color(163, 163, 163), ColorSets.color(255, 255, 255), ColorSets.color(128, 0, 128));
        ColorSets.addColorSet("aromantic", ColorSets.color(61, 165, 66), ColorSets.color(167, 211, 121), ColorSets.color(255, 255, 255), ColorSets.color(169, 169, 169), ColorSets.color(0, 0, 0));
        ColorSets.addColorSet("nonbinary", ColorSets.color(252, 244, 52), ColorSets.color(255, 255, 255), ColorSets.color(156, 89, 209), ColorSets.color(0, 0, 0));
    }

    public static class ColorSet {
        public String name;
        public Integer[][] colors;

        public ColorSet(String name, Integer[] ... colors) {
            this.name = name;
            this.colors = colors;
        }

        private void addToMap() {
            COLOR_SETS.put(this.name, this);
        }
    }
}

